<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:p="http://www.sec.gov/edgar/ta/tatwofiler">

	<xsl:template name="item2_registrationInfo">
	<h1><xsl:value-of select="$submissionType"/>: Registration Information</h1>
		<table role="presentation">
			<tr>
				<td class="label">
					<b>3(a).</b> Registrant's appropriate regulatory agency (ARA):
				</td>
				<td>
					<p>
						<div class="fakeBox">
							<xsl:value-of select="string(p:formData/p:registrantRegulatoryAgency/p:regulatoryAgency)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
		</table>
		<table role="presentation" >	
			<tr>
				<td class="label">
					<b>3(b).</b> During the reporting period, has the Registrant
					amended for TA-1 within 60 calendar days following the date on
					which information reported therein became inaccurate, incomplete
					or
					misleading?
				</td>
				<td>
					<div>
						<xsl:choose>
							<xsl:when test="p:formData/p:registrantRegulatoryAgency/p:amendmentFiled = 'Yes, filed amendment(s)'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Yes, filed amendment(s)<br/>
						<xsl:choose>
							<xsl:when test="p:formData/p:registrantRegulatoryAgency/p:amendmentFiled = 'No, failed to file amendment(s)'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;No, failed to file amendment(s)<br/>
						<xsl:choose>
								<xsl:when test="p:formData/p:registrantRegulatoryAgency/p:amendmentFiled = 'Not applicable'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Not applicable<br/>
					</div>
				</td>			
			</tr>
		</table>
		<table role="presentation" style ="TABLE-LAYOUT: fixed;">
			<tr>
				<td  class="label">
						<b>3(c).</b> If the answer to subsection (b) is no, provide an explanation:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:registrantRegulatoryAgency/p:additionalInformation"/>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>